using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;
using System.IO;

namespace LoadCovers
{
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form
    {

        SqlConnection cn; 
        bool bolStart;

        internal System.Windows.Forms.CheckBox cbLoad;
        internal System.Windows.Forms.ComboBox cmbISBNs;
        internal System.Windows.Forms.Button btnRun;
        internal System.Windows.Forms.PictureBox PbCover;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1()
        {
            try
            {
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                //
                // TODO: Add any constructor code after InitializeComponent call
                //
                cn = new SqlConnection("data source=.;database=biblio;trusted_connection=yes");
                bolStart = true;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }

        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if (components != null) 
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.cbLoad = new System.Windows.Forms.CheckBox();
            this.cmbISBNs = new System.Windows.Forms.ComboBox();
            this.btnRun = new System.Windows.Forms.Button();
            this.PbCover = new System.Windows.Forms.PictureBox();
            this.SuspendLayout();
            // 
            // cbLoad
            // 
            this.cbLoad.Location = new System.Drawing.Point(24, 256);
            this.cbLoad.Name = "cbLoad";
            this.cbLoad.Size = new System.Drawing.Size(112, 24);
            this.cbLoad.TabIndex = 7;
            this.cbLoad.Text = "Reload Pictures?";
            // 
            // cmbISBNs
            // 
            this.cmbISBNs.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cmbISBNs.Location = new System.Drawing.Point(8, 208);
            this.cmbISBNs.Name = "cmbISBNs";
            this.cmbISBNs.Size = new System.Drawing.Size(328, 21);
            this.cmbISBNs.TabIndex = 6;
            this.cmbISBNs.SelectedIndexChanged += new System.EventHandler(this.cmbISBNs_SelectedIndexChanged);
            // 
            // btnRun
            // 
            this.btnRun.Location = new System.Drawing.Point(176, 256);
            this.btnRun.Name = "btnRun";
            this.btnRun.TabIndex = 5;
            this.btnRun.Text = "Run";
            this.btnRun.Click += new System.EventHandler(this.btnRun_Click);
            // 
            // PbCover
            // 
            this.PbCover.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.PbCover.Location = new System.Drawing.Point(8, 16);
            this.PbCover.Name = "PbCover";
            this.PbCover.Size = new System.Drawing.Size(328, 184);
            this.PbCover.TabIndex = 4;
            this.PbCover.TabStop = false;
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(344, 310);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.cbLoad,
                                                                          this.cmbISBNs,
                                                                          this.btnRun,
                                                                          this.PbCover});
            this.Name = "Form1";
            this.Text = "Form1";
            this.ResumeLayout(false);

        }
#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() 
        {
            Application.Run(new Form1());
        }

        private void btnRun_Click(object sender, System.EventArgs e)
        {
            try
            {
                if (cn.State == ConnectionState.Closed)
                {
                    cn.Open();
                }
                SqlDataAdapter da = new SqlDataAdapter("SELECT ISBN, Filename, Version FROM Covers", cn);
                DataTable tb = new DataTable();
                da.Fill(tb);
                cmbISBNs.DataSource = tb;
                cmbISBNs.DisplayMember = "ISBN";
                if (cbLoad.Checked)

                    for(int i = 0; i <= (tb.Rows.Count - 1); i++)
                    {
                        string isbn, fn, ver;
                        fn = tb.Rows[i]["Filename"].ToString().Trim();                     //C:\Cover Pictures\M13544x.bmp"
                        ver = tb.Rows[i]["Version"].ToString().Trim();
                        FileStream strm = new FileStream(fn, FileMode.Open);
                        byte[] aData;
                        aData =new byte[strm.Length];
                        isbn = "1-5561" + fn.Substring(20,3) + "-" + fn.Substring(23, 1) + "-" + fn.Substring(24, 1);   // 1-5561135-4-4
                        Console.WriteLine(isbn);
                        strm.Read(aData, 0, Convert.ToInt32(strm.Length));
                        strm.Close();
                        SqlCommand cmd = new SqlCommand();
                        cmd.Connection = cn;
                        cmd.CommandText = "Update NewCovers Set Cover = @CoverBLOB Where ISBN = @ISBNWanted";
                        cmd.Parameters.Add("@ISBNWanted", isbn);
                        cmd.Parameters.Add("@CoverBLOB", SqlDbType.Image, aData.Length);
                        cmd.Parameters["@CoverBLOB"].Value = aData;
                        cmd.ExecuteNonQuery();
                        cmd.Dispose();
                    }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
            // take off the event handler inhibitor boolean that we set up 
            // since we ahve now populated the combo box... and fire the SelectedIndexChanged Event.
            // in order to get the first picture loaded...
            bolStart = false;
            cmbISBNs_SelectedIndexChanged(this,e);
        }

        private void cmbISBNs_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            try
            {
                if (bolStart) return;
                byte[] aData;
                string isbn;
                isbn = cmbISBNs.Text;
                SqlCommand cmd = new SqlCommand();
                cmd = cn.CreateCommand();
                cmd.CommandText = "SELECT ISBN, Cover FROM Covers WHERE ISBN = '" + isbn + "'";
                SqlDataReader rdr = cmd.ExecuteReader(CommandBehavior.SequentialAccess);
                string newFn = "loadpicture###.bmp";
                if (rdr.Read())
                {
                    if (PbCover.Image != null)
                    {
                        PbCover.Image.Dispose();
                    }
                    File.Delete(newFn);

                    int intChunkSize, intBytesReturned, intNumChunks=0;
                    FileStream strm = new FileStream(newFn, FileMode.CreateNew);
                    intChunkSize = 256; //128698; //262144 //256K

                    aData = new byte[intChunkSize];

                    do
                    {
                        intBytesReturned = Convert.ToInt32(rdr.GetBytes(1, intNumChunks * intChunkSize, aData, 0, intChunkSize));
                        if (intBytesReturned > 0)
                        {
                            strm.Write(aData, 0, intBytesReturned);
                            intNumChunks += 1;
                            if (intBytesReturned < intChunkSize)
                            {
                                break; 
                            }
                        }
                        else
                        {
                            break;
                        }

                    }while (true);
                    rdr.Close();
                    strm.Close();
                    cmd.Dispose();

                    PbCover.Image = Image.FromFile(newFn);


                }
                else
                {
                    MessageBox.Show("Uh oh!");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }

        }
    }
}
